clear 

set more off

***download state annual average unemployment data from  http://www.bls.gov/lau/rdscnp16.htm***

***save in computer, delete first seven rows***

*insheet using "State_urate_data.csv"





rename v2 state

rename v10 urate

rename v3 year
***get rid of NYC, LA***
drop if state == "Los Angeles County" | state == "New York city"



drop if missing(urate)



gen year_group = 1 if year>=1982 & year<=2007
replace year_group = 2 if year==2013

drop if missing(year_group)

label define year_group 1 "1982-2007" 2 "2013"

label var year_group year_group 

collapse (mean) urate, by(state year_group)

***round to nearest tenth***
gen round_urate = round(urate,.1)

bysort state (year_group): gen atorbelowavg = (round_urate <= round_urate[_n-1]  & year_group==2) 

tab state if atorbelowavg  ==1

***these are our 11 states below average***

/*
      State and area |      Freq.     Percent        Cum.
---------------------+-----------------------------------
              Alaska |          1        9.09        9.09
                Iowa |          1        9.09       18.18
           Louisiana |          1        9.09       27.27
             Montana |          1        9.09       36.36
        North Dakota |          1        9.09       45.45
            Oklahoma |          1        9.09       54.55
               Texas |          1        9.09       63.64
                Utah |          1        9.09       72.73
             Vermont |          1        9.09       81.82
       West Virginia |          1        9.09       90.91
             Wyoming |          1        9.09      100.00
---------------------+-----------------------------------
               Total |         11      100.00

*/
